<?php
/* --------------------------------------------------------------
  StyleEditServiceFactory.inc.php 2019-09-12
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/
MainFactory::load_class(StyleEditServiceInterface::class);
MainFactory::load_class(StyleEdit4Service::class);
MainFactory::load_class(StyleEdit3Service::class);

/**
 * Class StyleEditServiceFactory
 *
 */
class StyleEditServiceFactory
{
    /**
     * @var StyleEditServiceInterface
     */
    protected static $service;
    
    
    /**
     * @return StyleEditServiceInterface
     */
    public static function service(): StyleEditServiceInterface
    {
        if (self::$service === null) {
            /**
             * @var ViewSettings
             */
            //$viewSettings = StaticGXCoreLoader::getService('ViewSettings')->get();
            $se4Service   = MainFactory::create(StyleEdit4Service::class);
            
            if (MainFactory::_isThemeSystemActive() || $se4Service->isThemeSystemActive()) {
                self::$service = $se4Service;
            } else {
                self::$service = MainFactory::create(StyleEdit3Service::class);
            }
        }
        
        return self::$service;
    }
    
    
}